/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.impl.block;

import compasses.expandedstorage.api.EsChestType;
import compasses.expandedstorage.impl.CommonMain;
import compasses.expandedstorage.impl.block.AbstractChestBlock;
import compasses.expandedstorage.impl.block.entity.ChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.OldChestBlockEntity;
import compasses.expandedstorage.impl.block.entity.extendable.OpenableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChestBlock
extends AbstractChestBlock
implements SimpleWaterloggedBlock {
    public static final int SET_OBSERVER_COUNT_EVENT = 1;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{ChestBlock.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0), ChestBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};
    private static final VoxelShape[] UPSIDE_DOWN_SHAPES = new VoxelShape[]{ChestBlock.m_49796_((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0), ChestBlock.m_49796_((double)0.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), ChestBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public ChestBlock(BlockBehaviour.Properties settings, ResourceLocation openingStat, int slotCount) {
        super(settings, openingStat, slotCount);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter blockLevel, BlockPos pos, CollisionContext context) {
        boolean upsideDown = false;
        BlockEntity blockEntity = blockLevel.m_7702_(pos);
        if (blockEntity instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            upsideDown = entity.isDinnerbone();
        }
        EsChestType type = (EsChestType)((Object)state.m_61143_((Property)CURSED_CHEST_TYPE));
        if (upsideDown) {
            if (type == EsChestType.TOP) {
                return UPSIDE_DOWN_SHAPES[4];
            }
            if (type == EsChestType.BOTTOM) {
                return UPSIDE_DOWN_SHAPES[5];
            }
            if (type == EsChestType.SINGLE) {
                return UPSIDE_DOWN_SHAPES[6];
            }
            int index = (((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() + type.getOffset()) % 4;
            return UPSIDE_DOWN_SHAPES[index];
        }
        if (type == EsChestType.TOP) {
            return SHAPES[4];
        }
        if (type == EsChestType.BOTTOM) {
            return SHAPES[5];
        }
        if (type == EsChestType.SINGLE) {
            return SHAPES[6];
        }
        int index = (((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_() + type.getOffset()) % 4;
        return SHAPES[index];
    }

    @Override
    protected void appendAdditionalStateDefinitions(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState otherState, LevelAccessor level, BlockPos pos, BlockPos otherPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, otherState, level, pos, otherPos);
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    protected <T extends OldChestBlockEntity> BlockEntityType<T> getBlockEntityType() {
        return CommonMain.getChestBlockEntityType();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.m_5776_() && blockEntityType == this.getBlockEntityType() ? ChestBlockEntity::progressLidAnimation : null;
    }

    public boolean m_8133_(BlockState state, Level level, BlockPos pos, int event, int value) {
        super.m_8133_(state, level, pos, event, value);
        BlockEntity blockEntity = level.m_7702_(pos);
        return blockEntity != null && blockEntity.m_7531_(event, value);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity entity = (ChestBlockEntity)blockEntity;
            entity.updateViewerCount(level, pos, state);
        }
    }

    @Override
    public boolean isAccessBlocked(LevelAccessor level, BlockPos pos) {
        OpenableBlockEntity entity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof OpenableBlockEntity && (entity = (OpenableBlockEntity)blockEntity).isDinnerbone()) {
            BlockPos belowPos = pos.m_7495_();
            return level.m_8055_(belowPos).m_60796_((BlockGetter)level, belowPos);
        }
        return net.minecraft.world.level.block.ChestBlock.m_51508_((LevelAccessor)level, (BlockPos)pos);
    }

    @Override
    protected boolean areChestsCompatible(Level level, ItemStack itemInHand, BlockPos firstPos, BlockPos secondPos) {
        OpenableBlockEntity second;
        boolean firstIsDinnerbone = itemInHand.m_41786_().getString().equals("Dinnerbone");
        BlockEntity blockEntity = level.m_7702_(secondPos);
        boolean secondIsDinnerbone = blockEntity instanceof OpenableBlockEntity && (second = (OpenableBlockEntity)blockEntity).isDinnerbone();
        return firstIsDinnerbone == secondIsDinnerbone;
    }
}

